<?php

/*
Plugin Name: Don't Update Some Plugins
Plugin URI: https://nova-seo.com
Description: This doesn't update some plugins
Author: NOWA
Author URI: https://nova-seo.com
License: GPL2
*/



add_filter( 'auto_update_plugin', 'do_not_auto_update_specific_plugins', 10, 2 );
// Don't update some plugins
function do_not_auto_update_specific_plugins ( $update, $item ) {
    // Array of plugin slugs to never auto-update
    $plugins = array ( 
        'igniteup',
        'wp-statistics',
    );
    if ( in_array( $item->slug, $plugins ) ) {
        return false; // Never update plugins in this array
    } else {
        return true; // Else update the rest
    }
}



function disable_plugin_updates( $value ) {

    $pluginsToDisable = [
        'wp-statistics/wp-statistics.php',
        'igniteup/igniteup.php'
    ];

    if ( isset($value) && is_object($value) ) {
        foreach ($pluginsToDisable as $plugin) {
            if ( isset( $value->response[$plugin] ) ) {
                unset( $value->response[$plugin] );
            }
        }
    }
    return $value;
}
add_filter( 'site_transient_update_plugins', 'disable_plugin_updates' );