<?php

namespace AmeliaBooking\Infrastructure\WP\Integrations\ThriveAutomator\Triggers\Booking;

use AmeliaBooking\Infrastructure\WP\Integrations\ThriveAutomator\Apps\AmeliaBooking;
use AmeliaBooking\Infrastructure\WP\Integrations\ThriveAutomator\DataObjects\EventBookingData;
use Thrive\Automator\Items\Trigger;

class EventBookingCanceled extends Trigger
{
    public static function get_id()
    {
        return 'ameliabooking/event-booking-canceled-trigger';
    }

    public static function get_wp_hook()
    {
        return 'AmeliaEventBookingCanceled';
    }

    public static function get_provided_data_objects()
    {
        return [
            EventBookingData::get_id(),
        ];
    }

    public static function get_hook_params_number()
    {
        return 1;
    }

    public static function get_app_id()
    {
        return AmeliaBooking::get_id();
    }

    public static function get_name()
    {
        return 'Event Booking Canceled';
    }

    public static function get_description()
    {
        return 'When event booking is canceled';
    }

    public static function get_image()
    {
        return AMELIA_URL . 'public/img/amelia-logo-symbol.svg';
    }
}
