<?php

namespace AmeliaBooking\Infrastructure\WP\Integrations\ThriveAutomator\Triggers\Booking;

use AmeliaBooking\Infrastructure\WP\Integrations\ThriveAutomator\Apps\AmeliaBooking;
use AmeliaBooking\Infrastructure\WP\Integrations\ThriveAutomator\DataObjects\EventBookingData;
use Thrive\Automator\Items\Trigger;

class EventBookingStatusUpdated extends Trigger
{
    public static function get_id()
    {
        return 'ameliabooking/event-booking-status-updated-trigger';
    }

    public static function get_wp_hook()
    {
        return 'AmeliaEventBookingStatusUpdated';
    }

    public static function get_provided_data_objects()
    {
        return [
            EventBookingData::get_id(),
        ];
    }

    public static function get_hook_params_number()
    {
        return 2;
    }

    public static function get_app_id()
    {
        return AmeliaBooking::get_id();
    }

    public static function get_name()
    {
        return 'Event Booking Status Changed';
    }

    public static function get_description()
    {
        return 'When event booking status is changed';
    }

    public static function get_image()
    {
        return AMELIA_URL . 'public/img/amelia-logo-symbol.svg';
    }
}
