<?php
/*
 * Page Name: PRO FEATURES 🚀
 */



$features = [
	[
		'icon'  => 'fa-solid fa-ellipsis-vertical',
		'bg'    => '#4EC477',
		'title' => __( 'Submenus', 'float-menu' ),
		'desc'  => __( 'By grouping related items under submenu, you can improve user experience by making navigation more intuitive and organized. Users can easily find the specific information they need without feeling overwhelmed by a long list of top-level menu items. ', 'float-menu' ),
	],

	[
		'icon'  => 'fa-solid fa-image',
		'bg'    => '#4EC477',
		'title' => __( 'Custom Icons', 'float-menu' ),
		'desc'  => __( 'Break free from the limitations of pre-defined icon libraries. Custom icons allow you to utilize any image or icon that complements your website\'s design. ', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-sync-alt',
		'bg'    => '#4EC477',
		'title' => __( 'Icon Settings', 'float-menu' ),
		'desc'  => __( 'Rotate and flip icons to enhance visual appeal.', 'float-menu' ),
	],


	[
		'icon'  => 'fa-solid fa-swatchbook',
		'bg'    => '#4EC477',
		'title' => __( 'Beautiful Animations', 'float-menu' ),
		'desc'  => __( 'Choose from 7 elegant animations to showcase your menu items.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-shapes',
		'bg'    => '#4EC477',
		'title' => __( 'Multiple Shapes & Sizes', 'float-menu' ),
		'desc'  => __( 'elect from various shapes (Square, Round, Rounded, Rounded-out) and adjust text and icon sizes to perfectly match your website\'s design.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-sliders fa-rotate-90',
		'bg'    => '#4EC477',
		'title' => __( 'Vertical Alignment', 'float-menu' ),
		'desc'  => __( 'Align your menu vertically wherever you position it on the screen (left or right side).', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-edit',
		'bg'    => '#4EC477',
		'title' => __( 'Extra Text & Label Fonts', 'float-menu' ),
		'desc'  => __( 'Display extended text descriptions and customize font styles for labels to provide detailed menu information.', 'float-menu' ),
	],


	[
		'icon'  => 'fa-solid fa-retweet',
		'bg'    => '#4EC477',
		'title' => __( 'Translate', 'float-menu' ),
		'desc'  => __( 'Empower your visitors to translate your website content in real-time. Integrate this link type to break down language barriers and cater to a global audience.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-share-alt',
		'bg'    => '#4EC477',
		'title' => __( 'Social Sharing', 'float-menu' ),
		'desc'  => __( 'Boost your website\'s reach by incorporating a "Share" link. Choose from a staggering 29 different social media services, allowing users to effortlessly share your content across their preferred platforms', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-exchange',
		'bg'    => '#4EC477',
		'title' => __( 'Next/Previous Post', 'float-menu' ),
		'desc'  => __( 'Simplify post navigation for readers. These link types automatically direct users to the next or previous post within the current category, keeping them engaged and exploring related content.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-file-download',
		'bg'    => '#4EC477',
		'title' => __( 'Forced Download', 'float-menu' ),
		'desc'  => __( 'Offer downloadable resources like brochures, ebooks, or software directly through your floating menus. This eliminates the need for users to navigate to separate download pages.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-arrows-v',
		'bg'    => '#4EC477',
		'title' => __( 'Scroll To Top/Bottom', 'float-menu' ),
		'desc'  => __( 'Provide users with convenient links to instantly scroll to the top or bottom of your webpage. This is particularly helpful for long pages or content-heavy sections.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-mouse-pointer',
		'bg'    => '#4EC477',
		'title' => __( 'Smooth Scroll', 'float-menu' ),
		'desc'  => __( 'Enhance user experience with smooth scrolling animations. This link type ensures a visually pleasing and seamless transition when users navigate to different sections of your webpage.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-arrows-v',
		'bg'    => '#4EC477',
		'title' => __( 'Print', 'float-menu' ),
		'desc'  => __( 'With a single click on the Print link, users can initiate the built-in printing function of their web browser. No more cumbersome text selection or manual copying.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-search',
		'bg'    => '#4EC477',
		'title' => __( 'Search', 'float-menu' ),
		'desc'  => __( 'Integrate a search function directly into your floating menu. This empowers users to quickly find specific information on your website, improving overall user experience.', 'float-menu' ),
	],

	[
		'icon'  => 'fa-solid fa-language',
		'bg'    => '#4EC477',
		'title' => __( 'Multilingual Support', 'float-menu' ),
		'desc'  => __( 'For websites catering to a global audience, Float Menu Pro allows you to restrict menu visibility to specific languages. This ensures users only see menus relevant to their chosen language setting.', 'float-menu' ),
	],

	[
		'icon'  => 'fa-solid fa-crosshairs',
		'bg'    => '#4EC477',
		'title' => __( 'Hiding/Showing', 'float-menu' ),
		'desc'  => __( 'Allows you to control the visibility of your floating menus based on the user\'s scroll position on the webpage.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-link',
		'bg'    => '#4EC477',
		'title' => __( 'Activate by URL', 'float-menu' ),
		'desc'  => __( 'Target specific pages based on URL parameters (e.g., show a floating menu only on a page with URL parameter)', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-handshake-alt',
		'bg'    => '#4EC477',
		'title' => __( 'Activate by Referrer URL', 'float-menu' ),
		'desc'  => __( 'To display different floating menus for visitors arriving from specific websites.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-window-restore',
		'bg'    => '#4EC477',
		'title' => __( 'Display Rules', 'float-menu' ),
		'desc'  => __( 'Control exactly where your popup appear using page types, post categories/tags, author pages, taxonomies and date archives.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-tablet-screen-button',
		'bg'    => '#4EC477',
		'title' => __( 'Devices Rules', 'float-menu' ),
		'desc'  => __( 'Ensure optimal menu visibility across all devices with options to hide/remove on specific screen sizes.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-users',
		'bg'    => '#4EC477',
		'title' => __( 'User Role Permissions', 'float-menu' ),
		'desc'  => __( 'Define which user roles (e.g., Administrator, Editor, Author) have the ability to see the menu items. This can be helpful for displaying internal menus relevant only to website administrators or managing menus for specific user groups.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-calendar-day',
		'bg'    => '#4EC477',
		'title' => __( 'Scheduling', 'float-menu' ),
		'desc'  => __( 'Schedule menu appearances based on specific days, times, and dates. This allows you to promote temporary events or campaigns without cluttering your website permanently.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-chart-line',
		'bg'    => '#4EC477',
		'title' => __( 'Deeper Analytics', 'float-menu' ),
		'desc'  => __( 'Empower with a deeper understanding of how users interact with your menu! This powerful feature allows you to track user clicks on specific menu items within Google Analytics.', 'float-menu' ),
	],
	[
		'icon'  => 'fa-solid fa-window-maximize',
		'bg'    => '#4EC477',
		'title' => __( 'Create Popup', 'float-menu' ),
		'desc'  => __( 'Configure popups that open upon clicking on menu items.', 'float-menu' ),
	],

];

?>

<div class="wowp-pro-upgrade">
    <div>
        <h3>Unlock PRO Features</h3>
        <p>Upgrade to Float Menu Pro and get advanced features like</p>
        <a href="https://wow-estore.com/item/float-menu-pro/" target="_blank" class="button button-primary">Get Float Menu Pro </a>
    </div>
    <dl class="wowp-pro__profits">
        <div class="wowp-pro__profit">
            <dt><span class="wpie-icon wpie_icon-money-time"></span>No Yearly Fees</dt>
            <dd>One-time payment. Use it forever.</dd>
        </div>
        <div class="wowp-pro__profit">
            <dt><span class="wpie-icon wpie_icon-refund"></span>14-Day Money-Back Guarantee</dt>
            <dd>Try it risk-free. Get a full refund if you’re not satisfied.</dd>
        </div>
        <div class="wowp-pro__profit">
            <dt><span class="wpie-icon wpie_icon-cloud-data-sync"></span>Lifetime Free Updates</dt>
            <dd>Always stay up to date — at no extra cost.</dd>
        </div>
        <div class="wowp-pro__profit">
            <dt><span class="wpie-icon wpie_icon-customer-support"></span>Priority Support</dt>
            <dd>Fast, friendly, and expert help whenever you need it.</dd>
        </div>
    </dl>

</div>

<div class="wowp-pro-features">

	<?php foreach ( $features as $feature ) : ?>

		<?php if ( ! empty( $feature['icon'] ) ): ?>
            <div class="wowp-pro-feature">
                <div class="wowp-pro-feature__icon">
                    <span class="<?php echo esc_attr( $feature['icon'] ); ?>"></span>
                </div>
                <div class="wowp-pro-feature__content">
                    <div class="wowp-pro-feature__title">
						<?php echo esc_html( $feature['title'] ); ?>
                    </div>
                    <div class="wowp-pro-feature__desc">
						<?php echo esc_html( $feature['desc'] ); ?>
                    </div>
                </div>
            </div>
		<?php endif; ?>
	<?php endforeach; ?>
</div>
<?php
