<?php

final class ITSEC_Malware_Scheduling_Settings_Page extends ITSEC_Module_Settings_Page {
	private $version = 1;
	
	
	public function __construct() {
		$this->id = 'malware-scheduling';
		$this->title = __( 'Malware Scan Scheduling', 'it-l10n-ithemes-security-pro' );
		$this->description = __( 'Protect your site with automated malware scans. When this feature is enabled, the site will be automatically scanned each day. If a problem is found, an email is sent to select users.', 'it-l10n-ithemes-security-pro' );
		$this->type = 'recommended';
		$this->pro = true;
		
		parent::__construct();
	}
	
	public function enqueue_scripts_and_styles() {
		wp_enqueue_style( 'itsec-malware-scheduling-admin-style', plugins_url( 'css/settings-page.css', __FILE__ ), array(), $this->version );
	}
	
	protected function render_description( $form ) {
		
?>
	<p><?php _e( 'This malware scan is powered by <a href="https://ithemes.com/sitecheck">Sucuri SiteCheck</a>. It checks for known malware, blacklisting status, website errors, and out-of-date software. Although the Sucuri team does its best to provide the best results, 100% accuracy is not realistic and is not guaranteed.', 'it-l10n-ithemes-security-pro' ); ?></p>
	<p><?php printf( __( 'Results of previous malware scans can be found on the <a href="%s">logs page</a>.', 'it-l10n-ithemes-security-pro' ), ITSEC_Core::get_logs_page_url( 'malware' ) ); ?></p>
<?php
		
	}
	
	protected function render_settings( $form ) {

	}
}

new ITSEC_Malware_Scheduling_Settings_Page();
