<?php

final class ITSEC_Malware_Scheduling_Validator extends ITSEC_Validator {
	public function get_id() {
		return 'malware-scheduling';
	}

	protected function sanitize_settings() {
		$this->preserve_setting_if_exists( array( 'email_contacts', 'email_notifications' ) );
		$this->set_previous_if_empty( 'sucuri_failing' );

		$this->sanitize_setting( 'bool', 'sucuri_failing', __( 'Sucuri API Unavailable', 'it-l10n-ithemes-security-pro' ) );
	}

	public function get_validated_contact( $contact ) {
		_deprecated_function( __METHOD__, '3.9.0' );

		return false;
	}

	public function get_available_admin_users_and_roles() {
		_deprecated_function( __METHOD__, '3.9.0' );

		return array(
			'users' => array(),
			'roles' => array(),
		);
	}
}

ITSEC_Modules::register_validator( new ITSEC_Malware_Scheduling_Validator() );
