<?php
/**
 * @package Logtracking
 */
/*
Plugin Name: Log tracker
Description: Service de récuperation de log pour les actions en administration
Version: 0.0.1
Author: Cometik
License: GPLv2 or later
Text Domain: logtracking
*/


// Make sure we don't expose any info if called directly
if ( !function_exists( 'add_action' ) ) {
	echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
	exit;
}

// Si c'est pas un admin on jette
if(is_admin()) {
	add_action('admin_head', 'logtracking_add_tracker' );
	add_action('admin_enqueue_scripts', 'logtracking_add_js_file');
}



function logtracking_add_tracker() {
	if(!defined('CAB')) {
		return;
	}

	$currentUser = wp_get_current_user();
	$cab = CAB;
	$user = $currentUser->user_login;
	$email = $currentUser->user_email;
	$role = (empty($currentUser->roles[0])) ? "inconnu" : $currentUser->roles[0];

	echo "<script>cab = '" . $cab . "'</script>";
	echo "<script>user = '" . $user . "'</script>";
	echo "<script>email = '" . $email . "'</script>";
	echo "<script>role = '" . $role . "'</script>";
}

function logtracking_add_js_file() {
	if(!defined('CAB')) {
		return;
	}

	wp_enqueue_script(
		'my_custom_script', 
		plugin_dir_url(__FILE__) . '/tracking.js',
		[],
		false,
		true
	);
}